#ifdef _FOR_SMART_LOADING_ONLY 
#include <..\OriginLab\XFWiz.h>///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
#include <event_utils.h>
#include <Operation.h>
#include <..\OriginLab\WksOperation.h> ///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
#endif
/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 11-07-2008 FIX_REOPEN_PA_OPJ_FILE_TO_RECALCULATE						*
 *	Folger 11/12/08 QA80-12488 v8.0969 CENTRALIZED_CODE_ABOUT_AUTO_UPDATE_MECHANISM_IN_WIZARD_OPERATION
 *	YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM					*
 *	Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
 *	Sim 11-21-2008 FIX_XF_WIZ_OP_FUNC_NAME										*
 *	Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
 *	Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE				*
 *	Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE				*
 *	Sim 01-14-2009 FIX_XFWIZ_OP_DISPLAY_THEME_NAME								*
 *	Sim 01-15-2009 QA80-12969 TEMP_FIX_RUN_XFWIZ_OP_ON_TEMPLATE_BOOK			*
 *	YuI 01/16/09 QA70-12969 PROPER_REUID_OF_WIZARD_OPERATION_TREE				*
 *	Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL										*
 *	Folger 02/12/09 UPDATE_EXECUTION_INFO_AFTER_CREATE_WIZ_OP					*
 *	Folger 03/11/09 QA80-13265 LAST_REPORT_LT_STRING_FOR_ALL_PA_GOALS_EXCEPT_FITTING
 *	Sim 06-05-2009 CENTRALIZE_ERROR_MSG											*
 *	Folger 08/07/09 QA80-13998 SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER
 *	Folger 08/07/09 QA80-13998-P1 OUTPUT_RANGE_LT_STRING_FAILS_TO_UPDATE_WHEN_RUN_PA_WITHOUT_AUTOUPDATE
 *	Folger 11/26/09 QA81-14753 PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE
 *	Folger 12/18/09 QA81-14860 REUID_PA_OUTPUTS_FOR_AUTO_UPDATE					*
 *	Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION				*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\WizOperation.h>


///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
//#include <Operation.h>
//#include "wksOperation.h" //---- CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER
///---END FIX_WIZ_OPERATION_LABEL

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
/*
// This is the prototype of the custom function which general wizard operation code should call to execute the analysis
// or to show dlg for ChangeParams.
///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
//typedef	int		(*PFNRUNWIZ)(UINT msg, TreeNode &tnWizTheme, TreeNode &tnWizIOs, DWORD dwOPUID, int nExeMode);
typedef	int		(*PFNRUNWIZ)(UINT msg, const XFWizTheme *pXFWizTheme, const XFWizInputOutputRange *pXFWizIO, DWORD dwOPUID, int nExeMode);
///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE

//////////////////////////////////////////////////////////////////////////
// class WizOperation
//////////////////////////////////////////////////////////////////////////
class OC_REGISTERED WizOperation	:	public	WksReportOperation
{
public:
	WizOperation();
	~WizOperation();

public:
	// virtual
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	//BOOL	SetThemeInputsOutputs(TreeNode &theme, TreeNode &trInputsOutputs, LPCSTR lpcszWizFuncFile, LPCSTR lpcszWizFunc, BOOL bOnRecalc);
	BOOL	SetThemeInputsOutputs(const XFWizTheme *pXFWizTheme, const XFWizInputOutputRange *pXFWizIO, LPCSTR lpcszWizFuncFile, LPCSTR lpcszWizFunc, BOOL bOnRecalc);
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	////------ Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
	//void	DestroyExecuteHelper();
	////------
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	
protected:
	// virtual
	int		ChangeParam();
	
	// virtual
	BOOL	executeWithRange(int nExeMode = OEXEM_ON_CREATE, DWORD dwExecCntrl = 0);

	// virtual
	bool	updateTreeBeforeRunning(TreeNode &trOp, BOOL bLocalize = FALSE);
	
	void	ClearAllInputOutput();
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	bool	SetRange(XFWizInputOutputRange *pXFWizIO, LPCSTR lpcszXFName, bool bInput, int& nIndex);
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE

private:
	//BOOL	GetThemeInputsOutputs(Tree &theme, TreeNode &trInputsOutputs);
	//BOOL	GetThemeInputsOutputs(TreeNode &theme, TreeNode &trInputsOutputs);
	
	BOOL		GetExternalNodes(Tree &trOp, TreeNode &tnTheme, TreeNode &tnInputsOutputs, TreeNode &tnWizInfo, BOOL bCreate = FALSE);
	PFNRUNWIZ	GetRunWiz(TreeNode &tnWizInfo);

	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	////------ Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
//private:
	//
	//OnBeforeAfterExecuteHelper*		m_pExecuteHelper;
	////------ End PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	///---Sim 01-15-2009 QA80-12969 TEMP_FIX_RUN_XFWIZ_OP_ON_TEMPLATE_BOOK
	void updateInputOutputUID(TreeNode &trInputsOutputs, const XFWizTheme &objXFWizTheme);
	///---END QA80-12969 TEMP_FIX_RUN_XFWIZ_OP_ON_TEMPLATE_BOOK
};
*/
///---END FIX_WIZ_OPERATION_LABEL


WizOperation::WizOperation()
{
}

WizOperation::~WizOperation()
{
}

// virtual
bool	WizOperation::updateTreeBeforeRunning(TreeNode &trOp, BOOL bLocalize)
{
	return true;
}

///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
/*
//------ Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
#define		STR_EXECUTE_HELPER_POINTER_TAGNAME		"ExecuteHelperPrt"

static	OnBeforeAfterExecuteHelper*		get_execute_helper(TreeNode& trOp)
{
	TreeNode trExecuteHelperPrt = tree_check_get_node(trOp, STR_EXECUTE_HELPER_POINTER_TAGNAME);
	return 	(OnBeforeAfterExecuteHelper*)trExecuteHelperPrt.nVal;
}
static	void							set_execute_helper(TreeNode& trOp, OnBeforeAfterExecuteHelper* pExecuteHelper)
{
	TreeNode trExecuteHelperPrt = tree_check_get_node(trOp, STR_EXECUTE_HELPER_POINTER_TAGNAME);
	trExecuteHelperPrt.nVal = (int)pExecuteHelper;
}

class OnBeforeAfterExecuteHelperPointerManager
{
public:
	OnBeforeAfterExecuteHelperPointerManager(TreeNode& trOp, OperationBase& op, int nExeMode)
	{
		OnBeforeAfterExecuteHelper *pExecuteHelper = new OnBeforeAfterExecuteHelper(op, nExeMode);
		set_execute_helper(trOp, pExecuteHelper);
		m_trOp = trOp;
		m_nExeMode = nExeMode;
	}
	~OnBeforeAfterExecuteHelperPointerManager()
	{
		/// if OEXEM_ON_CHANGEPARAM != m_nExeMode, then XFWizDlg need to call DestroyWizardOperationExecuteHelper to clean up execute helper
		if ( OEXEM_ON_CHANGEPARAM != m_nExeMode )
		{
			delete get_execute_helper(m_trOp);
			//set_execute_helper(m_trOp, NULL);
		}
	}
	
private:
	TreeNode							m_trOp;
	int									m_nExeMode;
};

void	WizOperation::DestroyExecuteHelper()
{
	Tree trOp;
	GetTree(trOp);
	OnBeforeAfterExecuteHelper*		pExecuteHelper = get_execute_helper(trOp);
	ASSERT(pExecuteHelper);
	delete pExecuteHelper;
	//set_execute_helper(trOp, NULL);
}
//------ End PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
*/
///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC

///---Sim 01-15-2009 QA80-12969 TEMP_FIX_RUN_XFWIZ_OP_ON_TEMPLATE_BOOK
/*
	trInputsOutputs
		|--Inputs (uids, .nVals)
		|--Outputs (uids, .nVals)
		|--Info
			|--Inputs
				|--XFNames (.strVals)
			|--Outputs
				|--XFNames (.strVals)
			|--TargetPage
*/
void WizOperation::updateInputOutputUID(TreeNode &trInputsOutputs, const XFWizTheme &objXFWizTheme)
{
	StringArray saXFs;
	if ( !objXFWizTheme.GetXFList(saXFs) )
		return;

	TreeNode trInputs = trInputsOutputs.Inputs;
	TreeNode trOutputs = trInputsOutputs.Outputs;
	
	vector<int> vInputRangeUIDs, vOutputRangeUIDs;
	vInputRangeUIDs = trInputs.nVals;
	vOutputRangeUIDs = trOutputs.nVals;
	
	TreeNode trInputXFNames = trInputsOutputs.Info.Inputs.XFNames;
	TreeNode trOutputXFNames = trInputsOutputs.Info.Outputs.XFNames;
	
	vector<string> vInputXFNames, vOutputXFNames;
	vInputXFNames = trInputXFNames.strVals;
	vOutputXFNames = trOutputXFNames.strVals;
	
	ASSERT( vInputRangeUIDs.GetSize() == vInputXFNames.GetSize() );
	ASSERT( vOutputRangeUIDs.GetSize() == vOutputXFNames.GetSize() );
	
	DataRange dr;
	int nIndexInput = 0, nIndexOutput = 0;
	for ( int nStep = 0; nStep < saXFs.GetSize(); nStep++ )
	{
		int ii;
		for ( ii = 0; ii < vInputXFNames.GetSize(); ii++ )
		{
			if ( 0 == vInputXFNames[ii].CompareNoCase(saXFs[nStep]) )
			{
				GetInput(dr, nIndexInput++);
				vInputRangeUIDs[ii] = dr.IsValid() ? dr.GetUID() : 0;
			}
		}
		
		for ( ii = 0; ii < vOutputXFNames.GetSize(); ii++ )
		{
			if ( 0 == vOutputXFNames[ii].CompareNoCase(saXFs[nStep]) )
			{
				GetOutput(dr, nIndexOutput++);
				vOutputRangeUIDs[ii] = dr.IsValid() ? dr.GetUID() : 0;
			}
		}
	}
	
	trInputs.nVals = vInputRangeUIDs;
	trOutputs.nVals = vOutputRangeUIDs;
}
///---END QA80-12969 TEMP_FIX_RUN_XFWIZ_OP_ON_TEMPLATE_BOOK

// virtual
BOOL	WizOperation::executeWithRange(int nExeMode, DWORD dwExecCntrl)
{
	//------ Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
	/*
	/// YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	OnBeforeAfterExecuteHelper clHelper(*this, nExeMode);
	/// end ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	*/
	//------ End PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	OnBeforeAfterExecuteHelper clHelper(*this, nExeMode);
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	
	Tree		trOp;
	GetTree(trOp);
	
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	////------ Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
	//OnBeforeAfterExecuteHelperPointerManager	clHelperPtrMngr(trOp, *this, nExeMode);
	////------
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	
	TreeNode			trTheme;
	TreeNode			tnWizIOs;
	TreeNode			tnWizInfo;
	if ( !GetExternalNodes(trOp, trTheme, tnWizIOs, tnWizInfo, FALSE) )
		//return run_wiz_nodlg(NULL, NULL, trTheme, tnWizIOs, GetUID()) = 0;
		return FALSE;
	
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	/////---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	//// hard code, need to improve!!!!!!
	//if ( trTheme.Shared.AutoUpdate )
	//{
		//trTheme.Shared.AutoUpdate.nVal = trOp.Operation.AutoUpdate.nVal;
	//}
	/////---END QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	PFNRUNWIZ			pfn = GetRunWiz(tnWizInfo);
	if ( pfn )
	{
		///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
		XFWizTheme objXFWizTheme(trTheme);
		
		/// YuI 01/16/09 QA70-12969 PROPER_REUID_OF_WIZARD_OPERATION_TREE
		//	///---Sim 01-15-2009 QA80-12969 TEMP_FIX_RUN_XFWIZ_OP_ON_TEMPLATE_BOOK
		//	// if ( bFromTemplate ) // how to know this op is from template?
		//		updateInputOutputUID(tnWizIOs, objXFWizTheme);
		//	///---END QA80-12969 TEMP_FIX_RUN_XFWIZ_OP_ON_TEMPLATE_BOOK
		/// end PROPER_REUID_OF_WIZARD_OPERATION_TREE
		
		XFWizInputOutputRange ojbXFWizIO(tnWizIOs);
		
		objXFWizTheme.SetAutoUpdateMode(trOp.Operation.AutoUpdate.nVal);
		objXFWizTheme.ClearThemeName(); ///---Sim 01-14-2009 FIX_XFWIZ_OP_DISPLAY_THEME_NAME
		///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
		
		//------ Folger 11/12/08 QA80-12488 v8.0969 CENTRALIZED_CODE_ABOUT_AUTO_UPDATE_MECHANISM_IN_WIZARD_OPERATION
		/*
		if (0 == pfn(WIZOPH_EXECUTE, trTheme, tnWizIOs, GetUID(TRUE), nExeMode))
		{
			SetTree(trOp);
			return TRUE;		// OK
		}
		*/
		
		/// SetTree(trOp) is not needed since WizOperation will be updated by SetThemeInputsOutputs
		UINT	nMsg = dwExecCntrl & OP_EXEC_CHANGE_PARAM ? WIZOPH_DO_CHANGE_PARAMS_WIZDLG : WIZOPH_EXECUTE;
		///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
		if ( dwExecCntrl & OP_EXEC_SHOW_DLG_SETTINGS )
			nMsg = WIZOPH_SHOW_WIZDLG_GUI;
		///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
		///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
		//if (0 == pfn(nMsg, trTheme, tnWizIOs, GetUID(TRUE), nExeMode))
		if (0 == pfn(nMsg, &objXFWizTheme, &ojbXFWizIO, GetUID(TRUE), nExeMode))
		///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
		{
			///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
			//SetTree(trOp);		//------ Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
			///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
			return TRUE;		// OK
		}
		//------ End CENTRALIZED_CODE_ABOUT_AUTO_UPDATE_MECHANISM_IN_WIZARD_OPERATION
	}
	return FALSE;
}

// virtual
int		WizOperation::ChangeParam()
{
	//------ Folger 11/12/08 QA80-12488 v8.0969 CENTRALIZED_CODE_ABOUT_AUTO_UPDATE_MECHANISM_IN_WIZARD_OPERATION
	/*
	TreeNode	trOp;
	GetTree(trOp);
	TreeNode			trTheme;
	TreeNode			tnWizIOs;
	TreeNode			tnWizInfo;
	if ( !GetExternalNodes(trOp, trTheme, tnWizIOs, tnWizInfo, FALSE) )
		//return open_wiz_dlg(NULL, NULL, trTheme, trInputsOutputs, GetUID());
		return FALSE;
		
	PFNRUNWIZ			pfn = GetRunWiz(tnWizInfo);
	if ( pfn )
	{
		if (0 == pfn(WIZOPH_DO_CHANGE_PARAMS_WIZDLG, trTheme, tnWizIOs, GetUID(TRUE), OEXEM_ON_CREATE))
		{
			return 1;		// OK
		}
	}
	
	return -1;		// not run (Cancel)
	*/
	/// YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	// not sure why called with OEXEM_ON_CREATE
	//	return Execute(OEXEM_ON_CREATE, OP_EXEC_CHANGE_PARAM) ? 1 : -1;
	return Execute(OEXEM_ON_CHANGEPARAM, OP_EXEC_CHANGE_PARAM) ? 1 : -1;
	/// end ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	//------ End CENTRALIZED_CODE_ABOUT_AUTO_UPDATE_MECHANISM_IN_WIZARD_OPERATION
}

///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
int		WizOperation::ShowWizGUI()
{
	return Execute(OEXEM_ON_CHANGEPARAM, OP_EXEC_SHOW_DLG_SETTINGS) ? 1 : -1;
}
///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION

#define		STR_OP_WIZ_EXTERNAL_NODE		"wizExtern"
#define		STR_OP_WIZ_EXTERNAL_THEME_NODE	"wizTheme"
#define		STR_OP_WIZ_EXTERNAL_IOS_NODE	"wizIOs"
#define		STR_OP_WIZ_EXTERNAL_INFO_NODE	"wizInfo"


BOOL	WizOperation::GetExternalNodes(Tree &trOp, TreeNode &tnWizTheme, TreeNode &tnWizIOs, TreeNode &tnWizInfo, BOOL bCreate)
{
	TreeNode		tnExtern;
	if ( bCreate )
		octree_tree_check_get_node(&tnExtern, &trOp, STR_OP_WIZ_EXTERNAL_NODE);
	else
		tnExtern = trOp.GetNode(STR_OP_WIZ_EXTERNAL_NODE);
	
	if ( !tnExtern.IsValid() )
		return FALSE;

	if ( bCreate )
		octree_tree_check_get_node(&tnWizTheme, &tnExtern, STR_OP_WIZ_EXTERNAL_THEME_NODE);
	else
		tnWizTheme = tnExtern.GetNode(STR_OP_WIZ_EXTERNAL_THEME_NODE);
	
	if ( !tnWizTheme.IsValid() )
		return FALSE;

	if ( bCreate )
		octree_tree_check_get_node(&tnWizIOs, &tnExtern, STR_OP_WIZ_EXTERNAL_IOS_NODE);
	else
		tnWizIOs = tnExtern.GetNode(STR_OP_WIZ_EXTERNAL_IOS_NODE);

	if ( !tnWizIOs.IsValid() )
		return FALSE;

	if ( bCreate )
		octree_tree_check_get_node(&tnWizInfo, &tnExtern, STR_OP_WIZ_EXTERNAL_INFO_NODE);
	else
		tnWizInfo = tnExtern.GetNode(STR_OP_WIZ_EXTERNAL_INFO_NODE);

	if ( !tnWizInfo.IsValid() )
		return FALSE;

	return TRUE;
}

///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
void	WizOperation::ClearAllInputOutput()
{
	int ii;
	DataRange dr;
	
	ii = 0;
	while ( GetInput(dr, ii++) )
		RemoveInput(dr);
	
	for ( ii = GetOutputCount()-1; ii >= 0; --ii )
	{
		GetOutput(dr, ii);
		if ( dr )
			RemoveOutput(dr);
	}
}
///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE

///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
bool	WizOperation::SetRange(XFWizInputOutputRange *pXFWizIO, LPCSTR lpcszXFName, bool bInput, int& nIndex)
{
	if ( NULL == pXFWizIO )
		return false;
	
	Array<DataRange&> arrdr;
	if ( pXFWizIO->Get(&arrdr, lpcszXFName, bInput) )
	{
		for( int nRange = 0; nRange < arrdr.GetSize(); nRange++ )
		{
			DataRange& dr = arrdr.GetAt(nRange);
			///---Sim 02-05-2009 Yuri fix #12969, not need temp fix
			/////---Sim 01-15-2009 QA80-12969 TEMP_FIX_RUN_XFWIZ_OP_ON_TEMPLATE_BOOK
			//// must keep strict order
			////if ( dr && dr.IsValid() && dr.GetNumData() > 0 )
			/////---END QA80-12969 TEMP_FIX_RUN_XFWIZ_OP_ON_TEMPLATE_BOOK
			if ( dr && dr.IsValid() && dr.GetNumData() > 0 )
			///---END Yuri fix #12969, not need temp fix
			{
				if ( bInput )
				{
					if ( SetInput(dr, nIndex++) < 0 )
						return false;
					///---Sim 12-05-2008 QA80-12159 FOLLOW_YURI_FIXING
					XYRange xy(dr);
					if ( xy )
					{
						DataPlot dp;
						int nr1 = 0;
						int nr2 = -1;
						int ii = 0;
						while( xy.GetPlot(dp, ii++, &nr1, &nr2) )
						{
							dp.RemoveDataMarker(nr1, nr2);
						}
					}
					///---END QA80-12159 FOLLOW_YURI_FIXING
				}
				else
				{
					if ( SetOutput(dr, nIndex++) < 0 )
						return false;
				}
			}
		}		
	}
	
	return true;
}
///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE

// virtual
///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
//BOOL	WizOperation::SetThemeInputsOutputs(TreeNode &theme, TreeNode &trInputsOutputs, LPCSTR lpcszWizFuncFile, LPCSTR lpcszWizFunc, BOOL bOnRecalc)
BOOL	WizOperation::SetThemeInputsOutputs(const XFWizTheme *pXFWizTheme, const XFWizInputOutputRange *pXFWizIO, LPCSTR lpcszWizFuncFile, LPCSTR lpcszWizFunc, BOOL bOnRecalc)
///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
{
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	//if (!theme.IsValid() || !trInputsOutputs.IsValid())
		//return FALSE;
	if ( NULL == pXFWizTheme || NULL == pXFWizIO )
		return FALSE;
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	
	Tree			trOp;
	GetTree(trOp);

	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	/////---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	//// hard code, need to improve!!!!!!
	//if ( theme.Shared.AutoUpdate )
	//{
		//trOp.Operation.AutoUpdate.nVal = theme.Shared.AutoUpdate.nVal;
	//}
	/////---END QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	trOp.Operation.AutoUpdate.nVal = pXFWizTheme->GetAutoUpdateMode();
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	
	TreeNode		tnWizTheme;
	TreeNode		tnWizIOs;
	TreeNode		tnWizInfo;
	if ( !GetExternalNodes(trOp, tnWizTheme, tnWizIOs, tnWizInfo, TRUE) )
		return FALSE;
	
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	//tnWizTheme.Replace(theme, TRUE, TRUE);
	//tnWizIOs.Replace(trInputsOutputs, TRUE, TRUE);
	pXFWizTheme->GetTree(tnWizTheme);
	pXFWizIO->GetTree(tnWizIOs);
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	
	/*
	TreeNode		trInputs = trInputsOutputs.Inputs;
	int				ni = 0;
	foreach (TreeNode tn in trInputs.Children)
	{
		if ( !tn.IsEmpty() )
		{
			DataRange		dr;
			dr.Create();
			dr.SetTree(tn, DRTREE_ONE_DATA);
			if ( dr.IsValid() )
			{
				Project.AddDataRange(dr);
				SetInput(dr, ni);
			}
			
		}
		
		++ni;
	}
	
	TreeNode		trOutputs = trInputsOutputs.Outputs;
	int				no = 0;
	foreach (tn in trOutputs.Children)
	{
		if ( !tn.IsEmpty() )
		{
			DataRange		dr;
			dr.Create();
			dr.SetTree(tn, DRTREE_ONE_DATA);
			if ( dr.IsValid() )
			{
				Project.AddDataRange(dr);
				SetOutput(dr, no);
			}
		}
		
		++no;
	}
	*/
	
	///---Sim 06-24-2008 WIZARD_SHOULD_SUPPORT_MULTI_INPUT_RANGE
	/*
	TreeNode trInput = trInputsOutputs.Input;
	TreeNode trOutputs = trInputsOutputs.Outputs;
	DataRange drInput;
	drInput = (DataRange) Project.GetObject(trInput.nVal);
	SetInput(drInput, 0);
	*/
	
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	//int ii;
	//
	//TreeNode trInputs = trInputsOutputs.Inputs;
	//TreeNode trOutputs = trInputsOutputs.Outputs;
	//
	//vector<int> vInputs;
	//vInputs = trInputs.nVals;
	//for( ii = 0; ii < vInputs.GetSize(); ii++ )
	//{
		/////---Sim 08-26-2008 CLEAN_CODE_FOR_RELIABLE_OP_RANGE
		///*
		//if( 0 == vInputs[ii] )
		//{
			//DataRange drCurrentInput;
			//GetInput(drCurrentInput, ii);
			//if ( drCurrentInput )
				//RemoveInput(drCurrentInput);
		//}
		//else
		//{
			//DataRange drInput;
			//drInput = (DataRange) Project.GetObject(vInputs[ii]);
			//if( drInput && drInput.IsValid() && drInput.GetNumData() > 0 )
				//SetInput(drInput, ii);
		//}
		//*/
		//DataRange drInput;
		//drInput = (DataRange) Project.GetObject(vInputs[ii]);
		//if ( drInput && drInput.IsValid() && drInput.GetNumData() > 0 )
		//{
			//if ( SetInput(drInput, ii) < 0 )
				//return FALSE;
			/////---Sim 12-05-2008 QA80-12159 FOLLOW_YURI_FIXING
			//XYRange xy(drInput);
			//if ( xy )
			//{
				//DataPlot dp;
				//int nr1 = 0;
				//int nr2 = -1;
				//int nIndex = 0;
				//while( xy.GetPlot(dp, nIndex, &nr1, &nr2) )
				//{
					//dp.RemoveDataMarker(nr1, nr2);
					//nIndex++;
				//}
			//}
			/////---END QA80-12159 FOLLOW_YURI_FIXING
		//}
		////else
		////{
			////GetInput(drInput, ii);
			////if ( drInput )
				////RemoveInput(drInput);
		////}		
		/////---END CLEAN_CODE_FOR_RELIABLE_OP_RANGE
	//}
	/////---END WIZARD_SHOULD_SUPPORT_MULTI_INPUT_RANGE
	//
	//vector<int> vOutputs;
	//vOutputs = trOutputs.nVals;
	//for( ii = 0; ii < vOutputs.GetSize(); ii++ )
	//{
		/////---Sim 08-26-2008 CLEAN_CODE_FOR_RELIABLE_OP_RANGE
		///*
		//if( 0 == vOutputs[ii] )
		//{
			//DataRange drCurrentOutput;
			//GetOutput(drCurrentOutput, ii);
			//if ( drCurrentOutput )
				//RemoveOutput(drCurrentOutput);
		//}
		//else
		//{
			//DataRange drOutput;
			//drOutput = (DataRange) Project.GetObject(vOutputs[ii]);
			//if( drOutput && drOutput.IsValid() && drOutput.GetNumData() > 0 )
				//SetOutput(drOutput, ii);
		//}
		//*/
		//DataRange drOutput;
		//drOutput = (DataRange) Project.GetObject(vOutputs[ii]);
		//if( drOutput && drOutput.IsValid() && drOutput.GetNumData() > 0 )
		//{
			//if ( SetOutput(drOutput, ii) < 0 )
				//return FALSE;
		//}
		////else
		////{
			////GetOutput(drOutput, ii);
			////if ( drOutput )
				////RemoveOutput(drOutput);
		////}		
		/////---END CLEAN_CODE_FOR_RELIABLE_OP_RANGE
	//}
	
	ClearAllInputOutput();
	
	StringArray saXFs;
	if ( !pXFWizTheme->GetXFList(saXFs) )
		return FALSE;

	int nIndexInput = 0, nIndexOutput = 0;
	for ( int nStep = 0; nStep < saXFs.GetSize(); nStep++ )
	{
		if ( !SetRange(pXFWizIO, saXFs[nStep], true, nIndexInput) )
			return FALSE;
		
		if ( !SetRange(pXFWizIO, saXFs[nStep], false, nIndexOutput) )
			return FALSE;
	}
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	
	///------ Folger 08/07/09 QA80-13998-P1 OUTPUT_RANGE_LT_STRING_FAILS_TO_UPDATE_WHEN_RUN_PA_WITHOUT_AUTOUPDATE
	/////------ Folger 03/11/09 QA80-13265 LAST_REPORT_LT_STRING_FOR_ALL_PA_GOALS_EXCEPT_FITTING
	//Array<DataRange&>	arrOutputs;
	//if ( pXFWizIO->Get(&arrOutputs, saXFs[saXFs.GetSize()-1], false) )
	//{
		//updateOutputsGlobalRangeStrings(arrOutputs, saXFs[saXFs.GetSize()-1]);
	//}
	/////------ End LAST_REPORT_LT_STRING_FOR_ALL_PA_GOALS_EXCEPT_FITTING
	///------ End OUTPUT_RANGE_LT_STRING_FAILS_TO_UPDATE_WHEN_RUN_PA_WITHOUT_AUTOUPDATE
	
	tnWizInfo.FuncFile.strVal = lpcszWizFuncFile;
	tnWizInfo.Func.strVal = lpcszWizFunc;
	
	SetTree(trOp);
	
	return TRUE;
}


PFNRUNWIZ	WizOperation::GetRunWiz(TreeNode &tnWizInfo)
{
	string		strFuncFile = tnWizInfo.FuncFile.strVal;
	string		strFunc = tnWizInfo.Func.strVal;
	//string		strGet;
	//strGet.Format("%s\\%s");
	///---Sim 11-07-2008 FIX_REOPEN_PA_OPJ_FILE_TO_RECALCULATE
	//PFNRUNWIZ	pfnRunWiz = Project.FindFunction(strFunc, strFuncFile);
	///---Sim 11-21-2008 FIX_XF_WIZ_OP_FUNC_NAME
	//PFNRUNWIZ	pfnRunWiz = Project.FindFunction(strFunc, "originlab\\"+strFuncFile, true);
	PFNRUNWIZ	pfnRunWiz = Project.FindFunction(strFunc, "originlab\\"+GetFileName(strFuncFile), true);
	///---END FIX_XF_WIZ_OP_FUNC_NAME
	///---END FIX_REOPEN_PA_OPJ_FILE_TO_RECALCULATE
	
	return pfnRunWiz;
}

///------ Folger 08/07/09 QA80-13998 SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER
TreeNode	WizOperation::GetWizThemeTree()
{
	Tree				trOp;
	GetTree(trOp);
	TreeNode			trTheme;
	TreeNode			tnWizIOs;
	TreeNode			tnWizInfo;
	if ( GetExternalNodes(trOp, trTheme, tnWizIOs, tnWizInfo, FALSE) )
		return trTheme;

	TreeNode	trJunk;
	return trJunk;
}
//------ End SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER

///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
/*
static void _clear_data_range_from_project(TreeNode &trInputsOutputs)
{
	int ii;
	TreeNode trInputs = trInputsOutputs.Inputs;
	TreeNode trOutputs = trInputsOutputs.Outputs;
	
	vector<int> vInputs;
	vInputs = trInputs.nVals;
	for( ii = 0; ii < vInputs.GetSize(); ii++ )
	{
		DataRange dr;
		dr = (DataRange) Project.GetObject(vInputs[ii]);
		Project.RemoveDataRange(dr);
	}
	
	vector<int> vOutputs;
	vOutputs = trOutputs.nVals;
	for( ii = 0; ii < vOutputs.GetSize(); ii++ )
	{
		DataRange dr;
		dr = (DataRange) Project.GetObject(vOutputs[ii]);
		Project.RemoveDataRange(dr);
	}
}
*/
///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE

///////////////////
// This function, which should have the same prototype as PFNDoWizOp, is called from outside code to initialize or update
// the operation.
///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
/*
int		DoWizardOperation(DWORD dwOPUID, TreeNode &tnWizTheme, TreeNode &tnWizIOs, LPCSTR lpcszWizFuncFile, LPCSTR lpcszWizFunc)
{
	if ( dwOPUID )			// recalculate
	{
		WizOperation		op;
		//OperationBase		op = Project.GetObject(dwOPUID);
		op = Project.GetObject(dwOPUID);
		//Operation		op = Project.GetObject(dwOPUID);
		if ( !op )
			return -1;
		if ( !op.SetThemeInputsOutputs(tnWizTheme, tnWizIOs, lpcszWizFuncFile, lpcszWizFunc, TRUE) )
		{
			_clear_data_range_from_project(tnWizIOs);
			ASSERT(FALSE);
			string strMessage = _L("Unable to establish autoupdate. Recalculate mode is set to NONE.\n");
			warning_msg_box(strMessage, false);
			op.DestroyInternal();
			return -1;
		}
	}
	else					// create operation
	{
		///---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
		// hard code, need to improve!!!!!!
		if ( tnWizTheme.Shared.AutoUpdate )
		{
			if ( AU_NONE == tnWizTheme.Shared.AutoUpdate.nVal )
				return 0; // none op
		}
		///---END QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
		
		bool				bInitOk = FALSE;
		OperationBase		&op = op_create("WizOperation", bInitOk);
		WizOperation		&wizop = (WizOperation&)op;
		///---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
		if ( !wizop )
			return -1;
		///---END QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
		if ( !wizop.SetThemeInputsOutputs(tnWizTheme, tnWizIOs, lpcszWizFuncFile, lpcszWizFunc, FALSE) )
		{
			_clear_data_range_from_project(tnWizIOs);
			string strMessage = _L("Unable to establish autoupdate. Recalculate mode is set to NONE.\n");
			warning_msg_box(strMessage, false);
			op.DestroyInternal();
			return -1;		// failed
		}
	}
	
	return 0;		// OK
}
*/

///------ Folger 08/07/09 QA80-13998-P1 OUTPUT_RANGE_LT_STRING_FAILS_TO_UPDATE_WHEN_RUN_PA_WITHOUT_AUTOUPDATE
class WizardOutputGlobalStringsManager
{
public:
	WizardOutputGlobalStringsManager(const XFWizTheme* pXFWizTheme, const XFWizInputOutputRange* pXFWizIO)
	{
		m_pXFWizTheme = pXFWizTheme;
		m_pXFWizIO = pXFWizIO;
		///------ Folger 11/26/09 QA81-14753 PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE
		m_bUpdated = FALSE;
		///------ End PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE
	}
	~WizardOutputGlobalStringsManager()
	{
		///------ Folger 11/26/09 QA81-14753 PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE
		//if ( NULL == m_pXFWizTheme || NULL == m_pXFWizIO )
			//return;
		//
		//StringArray saXFs;
		//if ( !m_pXFWizTheme->GetXFList(saXFs) )
			//return;
		//
		//m_pXFWizIO->UpdateOutputsGlobalRangeStrings(saXFs[saXFs.GetSize()-1]);
		Update();
		///------ End PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE
	}
	
	///------ Folger 11/26/09 QA81-14753 PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE
	void	Update()
	{
		if ( m_bUpdated )
			return;
		
		m_bUpdated = TRUE;
		
		if ( NULL == m_pXFWizTheme || NULL == m_pXFWizIO )
			return;

		StringArray saXFs;
		if ( !m_pXFWizTheme->GetXFList(saXFs) )
			return;

		m_pXFWizIO->UpdateOutputsGlobalRangeStrings(saXFs[saXFs.GetSize()-1]);
	}
	///------ End PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE

private:

	XFWizTheme*				m_pXFWizTheme;
	XFWizInputOutputRange*	m_pXFWizIO;
	///------ Folger 11/26/09 QA81-14753 PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE
	BOOL					m_bUpdated;
	///------ End PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE
};
///------ End OUTPUT_RANGE_LT_STRING_FAILS_TO_UPDATE_WHEN_RUN_PA_WITHOUT_AUTOUPDATE

///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
//int		DoWizardOperation(const XFWizTheme *pXFWizTheme, const XFWizInputOutputRange *pXFWizIO, LPCSTR lpcszWizFuncFile, LPCSTR lpcszWizFunc, DWORD dwOPUID) // = 0
int		DoWizardOperation(const XFWizTheme *pXFWizTheme, const XFWizInputOutputRange *pXFWizIO, LPCSTR lpcszWizFile, LPCSTR lpcszWizFunc, LPCSTR lpcszWizOPClass, DWORD dwOPUID) // = NULL, 0
///---END FIX_WIZ_OPERATION_LABEL
{
	if ( NULL == pXFWizTheme || NULL == pXFWizIO )
		return -1;
	
	///------ Folger 08/07/09 QA80-13998-P1 OUTPUT_RANGE_LT_STRING_FAILS_TO_UPDATE_WHEN_RUN_PA_WITHOUT_AUTOUPDATE
	WizardOutputGlobalStringsManager		clMngr(pXFWizTheme, pXFWizIO);
	///------ End OUTPUT_RANGE_LT_STRING_FAILS_TO_UPDATE_WHEN_RUN_PA_WITHOUT_AUTOUPDATE

	WizOperation		*pOP = NULL;
	if ( dwOPUID )			// recalculate
	{
		WizOperation &opwiz = (WizOperation&)Project.GetOperationObject(dwOPUID);
		pOP = &opwiz;
		
		if ( AU_NONE == pXFWizTheme->GetAutoUpdateMode() ) // delete existing operation
		{
			pXFWizIO->ClearAll();
			if ( pOP )
				pOP->DestroyInternal();
			return 0;
		}
		
	}
	else					// create operation
	{
		if ( AU_NONE == pXFWizTheme->GetAutoUpdateMode() ) // no operation
			return 0;
		
		bool				bInitOk = FALSE;
		///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
		//WizOperation &opwiz = (WizOperation&)op_create("WizOperation", bInitOk);
		string strWizOPClass = "WizOperation";
		LPCSTR lpcszWizOPFile = NULL;
		if ( lpcszWizOPClass && lpcszWizOPClass[0] != '\0' )
		{
			strWizOPClass = lpcszWizOPClass;
			lpcszWizOPFile = lpcszWizFile;
		}
		WizOperation &opwiz = (WizOperation&)op_create(strWizOPClass, bInitOk, 0, lpcszWizOPFile);
		///---END FIX_WIZ_OPERATION_LABEL
		pOP = &opwiz;
	}
	
	if ( NULL == pOP )
		return -1;
	
	LPCSTR lpcszWizFuncFile = lpcszWizFile; ///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
	if ( !pOP->SetThemeInputsOutputs(pXFWizTheme, pXFWizIO, lpcszWizFuncFile, lpcszWizFunc, (dwOPUID)? TRUE : FALSE) )
	{
		///------ Folger 11/26/09 QA81-14753 PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE
		clMngr.Update();
		///------ End PA_FAILS_TO_UPDATE_OUTPUT_GLOBAL_STRINGS_IF_AUTO_UPDATE_FORCED_TO_NONE
		pXFWizIO->ClearAll();
		pOP->DestroyInternal();
		
		///---Sim 06-05-2009 CENTRALIZE_ERROR_MSG
		/*
		string strMessage = _L("Unable to establish autoupdate. Recalculate mode is set to NONE.\n");
		warning_msg_box(strMessage, false);
		*/
		warning_msg_box(CER_NOT_ESTABLISH_AUTO_UPDATE, false);
		///---END CENTRALIZE_ERROR_MSG
		if ( dwOPUID )
			ASSERT(FALSE); // change parameter should keep same io structure
		
		return -1; // failed
	}
	
	pOP->UpdateExecutionInfo();		///------ Folger 02/12/09 UPDATE_EXECUTION_INFO_AFTER_CREATE_WIZ_OP
	
	///------ Folger 12/18/09 QA81-14860 REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
	//return 0;		// OK
	return pOP->GetUID();		// OK
	///------ End REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
}
///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE

///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
/*
//------ Folger 11/13/08 QA80-12488 v8.970 PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
void	DestroyWizardOperationExecuteHelper(DWORD dwOPUID)
{
	if ( dwOPUID == 0 )
		return;
	
	//WizOperation		op;
	//op = (OperationBase)Project.GetObject(dwOPUID);
	WizOperation&		op = (WizOperation&)Project.GetOperationObject(dwOPUID);
	Tree trOp;
	op.GetTree(trOp);
	if ( op )
		op.DestroyExecuteHelper();
}
//------ End PROPER_HANDING_ABOUT_WIZARD_OPERATION_EXECUTE_HELPER
*/
///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
